% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xls.fit.R
\name{xls.fit}
\alias{xls.fit}
\title{Fitting an eXtreme Least Squares Model}
\usage{
xls.fit(formula, data, error_weights = NULL, error_ahead_level = 4)
}
\arguments{
\item{formula}{An object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{A "data.frame" (with no missing values) object containing the variables in the model.}

\item{error_weights}{A numeric vector including error weights by order. If NULL, it is created automatically by error_ahead_level amount, decreasing at equal intervals.}

\item{error_ahead_level}{An integer which represents how many steps further the parameters will be optimized for each data point.}
}
\value{
A \code{lm} object whose coefficients are optimized by the mentioned method.
}
\description{
Almost the same interface as \code{stats::lm}.
Just includes two parameters more, error_weights and error_ahead_level
}
\examples{
df <- datasets::airquality

ordered_df <- df[with(df,order(Month,Day)),]

model <- xls.fit(Ozone ~ Solar.R + Wind + Temp,ordered_df,
error_weights = c(0.4,0.3,0.2,0.1),error_ahead_level = 4)
}
