% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pythonInterface.R
\name{convert}
\alias{convert}
\alias{fromRtclt}
\alias{toRtclt}
\title{Convert Proxy Objects between XRPython and reticulate}
\usage{
fromRtclt(obj, .ev = XRPython::RPython())

toRtclt(obj, .ev = XRPython::RPython())
}
\arguments{
\item{obj}{a proxy object, computed in XRPython for \code{toRtclt} or by reticulate for \code{fromRtclt}}

\item{.ev}{an XRPython evaluator, by default and usually the current evaluator.}
}
\description{
Packages XRPython and reticulate both support proxies for Python objects; that is, R objects that are
proxies for objects created in Python by evaluations in the respective packages.  Function \code{fromRtclt()}
returns the equivalent XRPython proxy object given a reticulate object.
Function \code{toRtclt()} returns the equivalent reticulate proxy object given an XRPython object.
Normally, no copying is involved in either direction.
}
\section{Functions}{
\itemize{
\item \code{fromRtclt}: Convert from reticulate to XRPython

\item \code{toRtclt}: Convert from XRPython to reticulate
}}

