% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R, R/ProxyClass.R
\docType{methods}
\name{asServerObject}
\alias{asServerObject}
\alias{asServerObject,name-method}
\alias{asServerObject,AssignedProxy-method}
\alias{asServerObject,ProxyFunction-method}
\alias{asServerObject,ProxyClassObject-method}
\title{Generate a Server Language Expression corresponding to an R Object}
\usage{
asServerObject(object, prototype)

\S4method{asServerObject}{name}(object, prototype)

\S4method{asServerObject}{AssignedProxy}(object, prototype)

\S4method{asServerObject}{ProxyFunction}(object, prototype)

\S4method{asServerObject}{ProxyClassObject}(object, prototype)
}
\arguments{
\item{object}{The \R object.}

\item{prototype}{The proxy for a prototype of the server language object wanted.
When called from the `AsServerObject()` method of an evaluator, this argument is supplied
automatically from a class of objects for that evaluator, allowing methods to be defined
specialized to the various interface evalutor classes.}
}
\description{
Returns a string that can be inserted into a server language expression.
When parsed and evaluated by the server evaluator, the result
will be the appropriate object or data.
}
\details{
Methods for proxy objects and proxy class objects
will produce the name under which they were assigned.
The default method uses JSON to encode the object as a string and expects the server side
interface to have a function objectFromJSON() to decode the string.
}
\section{Methods (by class)}{
\itemize{
\item \code{name}: class "name" is used to pass unquoted strings, in case your
interface code did an explicit assign (but that's discouraged).

\item \code{AssignedProxy}: Proxy objects are just passed as their character string, although
a particular interface class could do something different, like refer to a table.

\item \code{ProxyFunction}: a proxy function just turns into its server language name.

\item \code{ProxyClassObject}: an object from a proxy class will be replaced by the name of the referenced object
}}

\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
