% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIM_ZINAR.R
\name{SIM_ZINAR}
\alias{SIM_ZINAR}
\title{Simulate values for ZINAR(1)}
\usage{
SIM_ZINAR(n, alpha, rho, th, innovation)
}
\arguments{
\item{n}{Number of realizations of the ZINAR(1) process.}

\item{alpha}{The probability of an element remaining in the process. The parameter alpha must be in [0,1].}

\item{rho}{The probability of the innovation be from the state zero. The parameter rho must be in [0,1].}

\item{th}{Is equal the value of the parameter lambda, if the innovations follow a Zero-Inflated Poisson (ZIP) distribution, and is a vector containing the values of the parameters (mu,phi), if the innovations follow a Zero-Inflated Negative Binomial (ZINB) or Zero-Inflated Inverse Gaussian (ZIPIG) distribution.}

\item{innovation}{Must be "Po" if Poisson, "NB" if Negative binomial or "GI" if Gaussian inverse.}
}
\value{
Returns a numeric vector representing a realization of a ZINAR(1) process.
}
\description{
This function generates realizations of a ZINAR(1) process.
}
\examples{

# Simulates values for ZIPInar1 model and estimate its parameters.

set.seed(5)

model = "zinar"
innv = "Po"
y = SIM_ZINAR(n = 500,alpha = 0.3,rho = 0.5,th = 3,innovation = innv)
ZIPInar1 = EST_ZINAR(y,model=model,innovation=innv,desc = TRUE)


}
\references{
Aldo M.; Medina, Francyelle L.; Jales, Isaac C.; Bertail, Patrice. First-order integer valued AR processes with zero-inflated innovations. Cyclostationarity: Theory and Methods, Springer Verlag - 2021, v. 1, p. 19-40.
}
