% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUd.R
\name{aSPUd}
\alias{aSPUd}
\title{Adaptive Sum of powered score (SPU) tests (SPU and aSPU) based on asymptotic distribution.}
\usage{
aSPUd(Y, X, cov = NULL, model = c("gaussian", "binomial"))
}
\arguments{
\item{Y}{phenotype data. It can be disease lables; =0 for controls, =1 for cases.
or It can be any quantitative traits. Vector with length n (number of observations)}

\item{X}{genotype data; each row for a subject, and each column
for an SNP. The value of each element is the # of the copies
for an allele. Matrix with dimension n by k (n : number of observation, k : number of genotype data)}

\item{cov}{covariates. Matrix with dimension n by p (n :number of observation, p : number of covariates)}

\item{model}{Use "gaussian" for quantitative trait (Default)
, and Use "binomial" for binary trait.}
}
\value{
p-values for SPU(1), SPU(2), minP tests and aSPU test.
}
\description{
It gives the p-values of the SPU(1), SPU(2) and minP tests and aSPUd test based on the asymptotic distribution.
}
\examples{

data(exdat)
out <- aSPUd(exdat$Y, exdat$X, cov = NULL, model = "binomial")
out

}
\references{
Gongjun Xu, Lifeng Lin, Peng Wei and Wei Pan (2016) An adaptive two-sample test for high-dimensional means, Biometrika (2016) 103 (3): 609-624.
}
\seealso{
\code{\link{aSPU}}
}
