% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getlogitp.R
\name{getlogitp}
\alias{getlogitp}
\title{Get the p-values of the multiple SNPs based on the Wald test in a logistic regresion model.}
\usage{
getlogitp(Y, X)
}
\arguments{
\item{Y}{Response or phenotype data. It can be a disease indicator; =0 for controls, =1 for cases.}

\item{X}{Genotype or other data; each row for a subject, and each column
for an SNP (or a predictor). The value of each SNP is the # of the copies
for an allele. A matrix with dimension n by p (n : number of observation, p : number of SNPs (or predictors) ).}
}
\value{
p-values for each SNPs.
}
\description{
Get p-value using logistic regresion for each of the multiple SNPs
}
\examples{

#simula <- simPathAR1Snp(nGenes=20, nGenes1=1, nSNPlim=c(1, 20), nSNP0=1:3,
#                           LOR=.2, rholim=c(0,0),
#                           n=10, MAFlim=c(0.05, 0.4), p0=0.05)
#logitp <- getlogitp(simula$Y, simula$X)


}
\seealso{
\code{\link{GATES2}} \code{\link{GatesSimes}} \code{\link{Hyst}}
}
