% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{DayOfBirth}
\alias{DayOfBirth}
\title{Day of Birth}
\format{A data frame with 7 observations on the following 2 variables.
\describe{ \item{day}{a character vector} \item{births}{a
numeric vector} }}
\source{
Ventura, S.J., J.A. Martin, S.C. Curtin, F. Menacker, and B.E.
Hamilton. 2001. Births: final data for 1999. \emph{National Vital Statistics
Reports} Vol. 49, No. 1.
}
\description{
Day of the week for 350 U.S. births in 1999.
}
\examples{
DayOfBirth
barchart( day ~ births, DayOfBirth, origin=0)

# Fix bad ordering of days
DayOfBirth$oday <- with(DayOfBirth, ordered(day, levels = day))
barchart( oday ~ births, DayOfBirth, origin=0)
barchart( births ~ oday, DayOfBirth, horizontal = FALSE, origin=0)
barchart( births ~ oday, DayOfBirth, horizontal = FALSE, origin=0,
 scales = list(x=list(rot=45)))

barplot(DayOfBirth$births,
  ylim = c(0, 70),
  names.arg = DayOfBirth$day,
  las = 2,
  mgp = c(3, 0.75, 0))
}
\references{
\url{http://cdc.gov/NCHS/products/nvsr.htm}
}
\keyword{datasets}

