% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{TsetseLearning}
\alias{TsetseLearning}
\title{Dietary Learning in Tsetse Flies}
\format{A data frame with 13 observations on the following 2 variables.
\describe{ \item{treatment}{a factor with levels \code{cow} and
\code{lizard}} \item{proportion.cow}{a numeric vector} }}
\source{
\emph{inferred from} Bouyer, J., M. Pruvot, Z. Bengaly, P.M. Guerin,
and R. Lancelot. 2007. Learning influences host choice in tsetse.
\emph{Biology Letters} 3: 113-116.
}
\description{
Dietary conditioning \code{treatment} and subsequent proportion of tsetse
flies (\emph{Glossina palpalis}) feeding on cow blood in each of 13 cohorts.
}
\examples{
xyplot(proportion.cow ~ treatment, TsetseLearning)
}
\references{
\url{http://rsbl.royalsocietypublishing.org/content/3/2/113.full}
}
\keyword{datasets}

