% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{euclidean}
\alias{euclidean}
\alias{rms_distance}
\alias{chord}
\alias{hellinger}
\alias{geodesic_metric}
\title{Euclidean and related distances}
\usage{
euclidean(x, y)

rms_distance(x, y)

chord(x, y)

hellinger(x, y)

geodesic_metric(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The distance between \code{x} and \code{y}. The chord distance,
  Hellinger distance, and geodesic metric are not defined if all elements
  of either vector are zero. We return \code{NaN} in this case.
}
\description{
These distance and diversity measures are mathematically similar to the
Euclidean distance between two vectors.
}
\details{
For vectors \code{x} and \code{y}, the Euclidean distance is defined as
\deqn{d(x, y) = \sqrt{\sum_i (x_i - y_i) ^ 2}.}
Relation of \code{euclidean()} to other definitions:
\itemize{
  \item Equivalent to R's built-in \code{dist()} function with
    \code{method = "euclidean"}.
  \item Equivalent to \code{vegdist()} with \code{method = "euclidean"}.
  \item Equivalent to the \code{euclidean()} function in
    \code{scipy.spatial.distance}.
  \item Equivalent to the \code{structeuclidean} calculator in Mothur, to
    \code{speciesprofile} if \code{x} and \code{y} are transformed to
    relative abundance, and to \code{memeuclidean} if \code{x} and \code{y}
    are transformed to presence/absence.
  \item Equivalent to \eqn{D_1}{D_1} in Legendre & Legendre.
  \item Equivalent to the \emph{distance between species profiles},
    \eqn{D_{18}}{D_18} in Legendre & Legendre if \code{x} and \code{y} are
    transformed to relative abundance.
}

The \emph{root-mean-square} distance or \emph{average} distance is similar
to Euclidean distance. As the name implies, it is computed as the square
root of the mean of the squared differences between elements of \code{x}
and \code{y}: \deqn{d(x, y) = \sqrt{\frac{1}{n} \sum_i^n (x_i - y_i) ^ 2}.}
Relation of \code{rms_distance()} to other definitions:
\itemize{
  \item Equivalent to \eqn{D_2}{D_2} in Legendre & Legendre.
}

The \emph{chord} distance is the Euclidean distance after scaling each
vector by its root sum of squares, \eqn{\sqrt{\sum_i x_i^2}}. The chord
distance between any two vectors ranges from 0 to \eqn{\sqrt{2}}{sqrt(2)}.
Relation of \code{chord()} to other definitions:
\itemize{
  \item Equivalent to \eqn{D_3}{D_3} in Legendre & Legendre.
}

The \emph{Hellinger} distance is equal to the chord distance computed after
a square-root transformation. Relation of \code{hellinger()} to other
definitions:
\itemize{
  \item Equivalent to \eqn{D_{17}}{D_17} in Legendre & Legendre.
  \item Equivalent to the \code{hellinger} calculator in Mothur.
}

The \emph{geodesic metric} is a transformed version of the chord distance.
\deqn{d(x, y) = \textrm{arccos} \left(1 - \frac{d_c^2(x, y)}{2} \right),}
where \eqn{d_c} is the chord distance. It gives the length of the arc on a
hypersphere between the vectors, if the vectors are normalized to unit
length. Relation of \code{geodesic_metric()} to other definitions:
\itemize{
  \item Equivalent to \eqn{D_4}{D_4} in Legendre & Legendre.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
y <- c(10, 2, 0, 1, 1, 0)
euclidean(x, y)
# The "distance between species profiles"
euclidean(x / sum(x), y / sum(y))
rms_distance(x, y)
chord(x, y)
hellinger(x, y)
# Hellinger is chord distance after square root transform
chord(sqrt(x), sqrt(y))
geodesic_metric(x, y)

# No species in common with x
v <- c(0, 0, 0, 5, 0, 5)
chord(v, x)
sqrt(2)
}
