% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{minkowski}
\alias{minkowski}
\title{Minkowski distance}
\usage{
minkowski(x, y, p = 1)
}
\arguments{
\item{x, y}{Numeric vectors.}

\item{p}{Exponent parameter, a single number greater than zero.}
}
\value{
The Minkowski distance between \code{x} and \code{y}.
}
\description{
The Minkowski metric is a generalized form of Euclidean (p=2) and Manhattan
(p=1) distance.
}
\details{
For vectors \code{x} and \code{y}, the Minkowski distance is defined as
\deqn{d(x, y) = \left( \sum_i |x_i - y_i|^p \right)^{1/p}.} Relation to
other definitions:
\itemize{
  \item Equivalent to R's built-in \code{dist()} function with
    \code{method = "minkowski"}.
  \item Equivalent to the \code{minkowski()} function in
    \code{scipy.spatial.distance}.
  \item Equivalent to \eqn{D_6}{D_6} in Legendre & Legendre.
}
The default value of \code{p = 1} makes this distance equal to the Manhattan
distance.
}
