% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{generate_data}
\alias{generate_data}
\title{Generate a Dataset for Simulations}
\usage{
generate_data(
  N,
  P,
  sigma_alpha = 1,
  sigma_gamma = 1,
  sigma_eps.d = 1,
  sigma_eps.y = 1,
  cov_eps = 0.5,
  rho = 0.5,
  theta = c(0.8, 1),
  seed = 202304
)
}
\arguments{
\item{N}{An integer specifying the number of individuals.}

\item{P}{An integer specifying the number of time periods.}

\item{sigma_alpha}{Standard deviation for the normal distribution from which the individual effect \code{alpha} is drawn; default is 1.}

\item{sigma_gamma}{Standard deviation for the normal distribution from which the time effect \code{gamma} is drawn; default is 1.}

\item{sigma_eps.d}{Standard deviation for the error term associated with the policy variable/treatment (\code{D}); default is \code{1}.}

\item{sigma_eps.y}{Standard deviation for the error term associated with the outcome/response variable (\code{Y}); default is \code{1}.}

\item{cov_eps}{Covariance between error terms of \code{Y} and \code{D}, default \code{0.5}.}

\item{rho}{Autocorrelation coefficient for \code{D} across time, default \code{0.5}.}

\item{theta}{Regression Coefficients for univariate AR(1) dynamic panal, default \code{c(0.8, 1)}.}

\item{seed}{Seed for random number generation, default \code{202304}.}
}
\value{
A list of two \code{P} x \code{N} matrices named \code{Y} (outcome/response variable) and \code{D} (policy variable/treatment).
}
\description{
Generates data according to the following process:
\eqn{Y_{it} = \alpha_{i} + \gamma_{t} + \theta_{1} Y_{i,t-1} + \theta_{2} D_{it} + \varepsilon_{it}} and
\eqn{D_{it} = \rho D_{i,t-1} + v_{i,t}}.
Note that \eqn{D_{it}} is predetermined with respect to \eqn{\varepsilon_{it}}.
}
\examples{
# Generate data using default parameters
data1 <- generate_data(N = 300, P = 40)
str(data1)

data2 <- generate_data(N = 500, P = 20)
str(data2)
}
