% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASDA.R
\name{predict.ASDA}
\alias{predict.ASDA}
\title{Predict method for sparse discriminant analysis}
\usage{
\method{predict}{ASDA}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Object of class ASDA. This object is returned from the function \code{\link{ASDA}}.}

\item{newdata}{A matrix of new observations to classify.}

\item{...}{Arguments passed to \code{\link[MASS]{predict.lda}}.}
}
\value{
A list with components:

\describe{
  \item{\code{class}}{The classification (a factor)}
  \item{\code{posterior}}{posterior probabilities for the classes}
  \item{\code{x}}{the scores}
}
}
\description{
Predicted values based on fit from the function \code{\link{ASDA}}. This
function is used to classify new observations based on their explanatory variables/features.
}
\note{
The input matrix newdata should be normalized w.r.t. the normalization
    of the training data
}
\examples{
    # Prepare training and test set
    train <- c(1:40,51:90,101:140)
    Xtrain <- iris[train,1:4]
    nX <- normalize(Xtrain)
    Xtrain <- nX$Xc
    Ytrain <- iris[train,5]
    Xtest <- iris[-train,1:4]
    Xtest <- normalizetest(Xtest,nX)
    Ytest <- iris[-train,5]

    # Define parameters for SDAD
    Om <- diag(4)+0.1*matrix(1,4,4) #elNet coef mat
    gam <- 0.01
    lam <- 0.01
    method <- "SDAD"
    q <- 2
    control <- list(PGsteps = 100,
                    PGtol = c(1e-5,1e-5),
                    mu = 1,
                    maxits = 100,
                    tol = 1e-3,
                    quiet = FALSE)

    # Run the algorithm
    res <- ASDA(Xt = Xtrain,
                Yt = Ytrain,
                Om = Om,
                gam = gam ,
                lam = lam,
                q = q,
                method = method,
                control = control)

    # Do the predictions on the test set
    preds <- predict(object = res, newdata = Xtest)
}
\seealso{
\code{\link{SDAAP}}, \code{\link{SDAP}} and \code{\link{SDAD}}
}
