% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{csh_from_digits}
\alias{csh_from_digits}
\title{Derive collapsing scheme from a hierarchical classification}
\usage{
csh_from_digits(x, levels = max(nchar(x)) - 1)
}
\arguments{
\item{x}{\code{[character|integer]} labels in a hierarchical classification (lowest level)}

\item{levels}{\code{[integer >=0]} how many collapsing levels to include. Zero means
only include the original labels.}
}
\value{
A data frame where each consecitive pair of columns represents
        one collapsing step induced by the hierarchical classification
        encoded by the digits in \code{x}.
}
\description{
Derive a collapsing scheme where group labels collapse to their
parents in the hierarchy.
}
\examples{
# balanced hierarchical classification
csh_from_digits(c("111","112","121","122","123"))
csh_from_digits(c("111","112","121","122","123"),levels=1)

# unbalanced hierarchical classification
csh_from_digits(c("111","112","121","122","1221","1222"))
csh_from_digits(c("111","112","121","122","1221","1222"),levels=2)

}
