% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_file_config_ini_new.R
\name{copy_file_config_ini_new}
\alias{copy_file_config_ini_new}
\title{Copy Configuration File from Outline in Working Directory}
\usage{
copy_file_config_ini_new(path_to = NULL, overwritefile = TRUE)
}
\arguments{
\item{path_to}{path where the configuration file will be copied}

\item{overwritefile}{logical variable;  if \code{TRUE} will overwrite the file if it already exists}
}
\value{
Copy configuration file from outline in working directory
}
\description{
Copy configuration file from outline in working directory
to search for additional terms in our R Markdown or LaTeX project.
}
\details{
The name of the configuration file is "addinsOutline_ini.txt".

In the configuration file you can use regular expressions with the help
of the functions of the "stringr" package,
to perform additional custom searches.

Make a copy of this file to see how new searches are defined.

The following strings serve to distinguish which types of files will be used:

- "rmd": R Markdown files

- "rmdbd": Bookdown files

- "tex": LaTeX files
}
\examples{
if (interactive()) {
   library(addinsOutline)
   copy_file_config_ini_new()
}
}
\seealso{
The function \code{\link{run_addinsOutline_Rmd}()},
\code{\link{run_addinsOutline_Rmd_bookdown}()} and
\code{\link{run_addinsOutline_tex}()}.
}
