% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersection.r
\name{intersection}
\alias{intersection}
\alias{intersection.Point1D}
\alias{intersection.Line2D}
\alias{intersection.Plane3D}
\alias{intersection.Coord1D}
\alias{intersection.Coord2D}
\alias{intersection.Coord3D}
\title{The intersection of two objects.}
\usage{
intersection(x, y, ...)

\method{intersection}{Point1D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{intersection}{Line2D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{intersection}{Plane3D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{intersection}{Coord1D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{intersection}{Coord2D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{intersection}{Coord3D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x, y}{The two objects to compute intersection for.}

\item{...}{Passed to other methods (or ignored).}

\item{tolerance}{Numerics with differences smaller
than \code{tolerance} will be considered \dQuote{equivalent}.}
}
\value{
A list of the object intersections (or \code{NULL} if no intersection).
}
\description{
\code{intersection()} is an S3 method that returns the intersection of two objects.
}
\details{
\code{affiner::intersection()} has the same S3 signature as
\code{euclid::intersection()} (so it shouldn't matter if one masks the other).
}
\examples{
line1 <- as_line2d("x-axis")
line2 <- as_line2d("y-axis")
line3 <- as_line2d(a = 0, b = 1, c = 2) # y + 2 = 0
intersection(line1, line1)
intersection(line1, line2)
intersection(line1, line3)
}
