% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_to_AA.r
\name{rotate3d_to_AA}
\alias{rotate3d_to_AA}
\title{Convert from 3D rotation matrix to axis-angle representation.}
\usage{
rotate3d_to_AA(
  mat = diag(4),
  unit = getOption("affiner_angular_unit", "degrees")
)
}
\arguments{
\item{mat}{3D rotation matrix (post-multiplied).
If you have a pre-multiplied rotation matrix
simply transpose it with \code{\link[=t]{t()}} to get a post-multiplied rotation matrix.}

\item{unit}{A string of the desired angular unit.  Supports the following strings
(note we ignore any punctuation and space characters as well as any trailing \code{s}'s
e.g. "half turns" will be treated as equivalent to "halfturn"):
\itemize{
\item "deg" or "degree"
\item "half-revolution", "half-turn", or "pi-radian"
\item "gon", "grad", "grade", or "gradian"
\item "rad" or "radian"
\item "rev", "revolution", "tr", or "turn"
}}
}
\description{
\code{rotate3d_to_AA()} converts from (post-multiplied) rotation matrix
to an axis-angle representation of 3D rotations.
}
\examples{
 # axis-angle representation of 90 degree rotation about the x-axis
 rotate3d_to_AA(rotate3d("x-axis", 90, unit = "degrees"))

 # find Axis-Angle representation of first rotating about x-axis 180 degrees
 # and then rotating about z-axis 45 degrees
 R <- rotate3d("x-axis", 180, unit = "degrees") \%*\%
        rotate3d("z-axis", 45, unit = "degrees")
 AA <- rotate3d_to_AA(R)

 # Can use `rotate3d()` to convert back to rotation matrix representation
 all.equal(R, do.call(rotate3d, AA))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Axis-angle_representation} for more details
about the Axis-angle representation of 3D rotations.
\code{\link[=rotate3d]{rotate3d()}} can be used to convert from an axis-angle representation to a rotation matrix.
}
