% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Descriptive.R
\name{show.test}
\alias{show.test}
\title{Print summaries of rank tests}
\usage{
show.test(res, pr = 0.05, n_tests = K - 1)
}
\arguments{
\item{res}{A list corresponding to the output of
\code{\link{estimate.affinity.matrix}},
\code{\link{estimate.affinity.matrix.lowrank}} or
\code{\link{estimate.affinity.matrix.unipartite}}.}

\item{pr}{A probability indicating the significance level required to pass a
rank test. Defaults to 0.05.}

\item{n_tests}{An integer indicating the number of tests to show. The
function prints the first \code{n_tests} rank tests. Defaults to
\code{min(nrow(Y),nrow(X))-1}.}
}
\value{
The function returns a long string in LaTeX style that can be
processed in the standard LaTeX tabular environment in order to display
the results from the first \code{n_tests} rank tests of the affinity
matrix.
}
\description{
This function prints the summaries of the first \code{n_tests} rank tests in
in LaTeX. The first row specifies the null hypothesis, the second row gives
the test statistic, the third the degrees of freedom and the fourth says
whether the null hypothesis passes the test at the \code{pr} level.
}
