% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{am_pivot_wider}
\alias{am_pivot_wider}
\title{Reshape Long API Data to Column-Based Format}
\usage{
am_pivot_wider(
  data,
  id_cols = intersect(c("ISO3", .AMT), names(data)),
  names_from = "Series",
  values_from = "Value",
  labels_from = if (any(names(data) == "Label")) "Label" else NULL,
  expand.date = FALSE,
  ...
)
}
\arguments{
\item{data}{raw data from the API: A long format data frame where all values are stacked in a value column.}

\item{id_cols}{character. Temporal identifiers of the data. By default all variables in \code{\link{.AMT}} and "ISO3" are selected.}

\item{names_from}{character. The column containing the series codes. These will become the names of the new columns in the wider data format.}

\item{values_from}{character. The column containing the data values.}

\item{labels_from}{character. The column containing the labels describing the series.}

\item{expand.date}{logical. \code{TRUE} will call \code{\link{am_expand_date}} on the data after reshaping.}

\item{\dots}{further arguments passed to \code{\link[collapse]{pivot}} or \code{\link{am_expand_date}}.}
}
\value{
A \code{\link[data.table]{data.table}} with the reshaped data.
}
\description{
This function automatically reshapes long (stacked) raw data from the API (\code{\link[=am_data]{am_data(..., wide = FALSE)}}) to a wide format where each variable has its own column.
It can also be used as a general purpose reshaping command - with an additional capability to handle variable labels.
}
\examples{
\donttest{
# Return all indicators for Kenya and Nigeria from the year 2000 onwards
am_pivot_wider(am_data(c("KEN", "NGA"), from = 2000, wide = FALSE))
}
}
\seealso{
\code{\link{am_pivot_longer}}, \code{\link{africamonitor}}
}
