% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{am_sources}
\alias{am_sources}
\title{Retrieve Data Sources Table}
\usage{
am_sources(ordered = TRUE)
}
\arguments{
\item{ordered}{logical. \code{TRUE} orders the result in the order data was entered into the database, while \code{FALSE} returns the result in a random order, to the benefit of faster query execution.}
}
\value{
A \code{\link[data.table]{data.table}} with information about the sources of data in the database.
}
\description{
This function retrieves a table with information about the sources of data in the database, and when data from different sources was updated.
}
\details{
The data source table gives information about the various sources / providers of data in this database, including the source website, frequency and time coverage of data, a description of the source, when data from the source was updated and the way data is accessed from the source.
}
\examples{
\donttest{
am_sources()
}
}
\seealso{
\code{\link{am_countries}}, \code{\link{am_series}}, \code{\link{africamonitor}}
}
