% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalWAgg.R
\name{IntervalWAgg}
\alias{IntervalWAgg}
\title{Aggregation Method: IntervalWAgg}
\usage{
IntervalWAgg(
  expert_judgements,
  type = "IntWAgg",
  name = NULL,
  placeholder = FALSE,
  percent_toggle = FALSE,
  round_2_filter = TRUE
)
}
\arguments{
\item{expert_judgements}{A dataframe in the format of \link{data_ratings}.}

\item{type}{One of \code{"IntWAgg"}, \code{"IndIntWAgg"}, \code{"AsymWAgg"}, \code{"IndIntAsymWAgg"}, \code{"VarIndIntWAgg"},
\code{"KitchSinkWAgg"}.}

\item{name}{Name for aggregation method. Defaults to \code{type} unless specified.}

\item{placeholder}{Toggle the output of the aggregation method to impute placeholder data.}

\item{percent_toggle}{Change the values to probabilities. Default is \code{FALSE}.}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}
}
\value{
A tibble of confidence scores \code{cs} for each \code{paper_id}.
}
\description{
Calculate one of several types of linear-weighted best estimates where the weights
are dependent on the lower and upper bounds of three-point elicitation (interval widths).
}
\details{
The width of the interval provided by individuals may be an indicator of certainty,
and arguably of accuracy of the best estimate contained between the bounds of the interval.

\code{type} may be one of the following:

\strong{IntWAgg}: Weighted according to the interval width across individuals for that claim, rewarding narrow interval widths.
\loadmathjax
\mjdeqn{w\_Interval_{i,c}= \frac{1}{U_{i,c} - L_{i,c}}}{ascii}
\mjdeqn{\hat{p}_c( IntWAgg) = \sum_{i=1}^N \tilde{w}\_Interval_{i,c}B_{i,c}}{ascii}

where \mjeqn{U_{i,d}  - L_{i,d}}{ascii} are individual \mjeqn{i}{ascii}'s judgements for claim \mjeqn{d}{ascii}. Then

\strong{IndIntWAgg}: Weighted by the rescaled interval width (interval width relative to largest
interval width provided by that individual)

Because of the variability in interval widths between individuals across claims,
it may be beneficial to account for this individual variability by rescaling interval
widths across all claims per individual. This results in a re-scaled interval width weight,
for individual \mjeqn{i}{ascii} for claim \mjeqn{c}{ascii}, relative to the widest interval provided by
that individual across all claims \mjeqn{C}{ascii}:

\mjdeqn{w\_nIndivInterval_{i,c}= \frac{1}{\frac{U_{i,c} - L_{i,c}}{max({ (U_{i,d}
- L_{i,d}): d = 1,\dots, C})}}}{ascii}

\mjdeqn{\hat{p}_c\left( IndIntWAgg \right) = \sum_{i=1}^N \tilde{w}\_nIndivInterval_{i,c}B_{i,c}}{ascii}

\strong{AsymWAgg}: Weighted by the asymmetry of individuals' intervals, rewarding increasing asymmetry.

We use the asymmetry of an interval relative to the corresponding best estimate
to define the following weights:

\mjdeqn{w\_asym_{i,c}= \begin{cases}
1 - 2 \cdot \frac{U_{i,c}-B_{i,c}}{U_{i,c}-L_{i,c}}, \text{for}\ B_{i,c} \geq
\frac{U_{i,c}-L_{i,c}}{2}+L_{i,c}\cr
1 - 2 \cdot \frac{B_{i,c}-L_{i,c}}{U_{i,c}-L_{i,c}}, \text{otherwise}
\end{cases}}{ascii}

then,

\mjdeqn{\hat{p}_c(AsymWAgg) = \sum_{i=1}^N \tilde{w}\_asym_{i,c}B_{i,c}.}{ascii}

\strong{IndIntAsymWAgg}: Weighted by individuals’ interval widths and asymmetry

This rewards both asymmetric and narrow intervals. We simply multiply the weights calculated
in the \code{"AsymWAgg"} and \code{"IndIntWAgg"} methods.

\mjdeqn{w\_nIndivInterval\_asym_{i,c} = \tilde{w}\_nIndivInterval_{i,c} \cdot \tilde{w}\_asym_{i,c}}{ascii}

\mjdeqn{\hat{p}_c( IndIntAsymWAgg) = \sum_{i=1}^N \tilde{w}\_nIndivInterval\_asym_{i,c}B_{i,c}}{ascii}

\strong{VarIndIntWAgg}: Weighted by the variation in individuals’ interval widths

A higher variance in individuals' interval width across claims may indicate a higher responsiveness
to the supporting evidence of different claims. Such responsiveness might be predictive of more
accurate assessors. We define:

\mjdeqn{w\_varIndivInterval_{i}= var{(U_{i,c} - L_{i,c}): c = 1,\dots, C},}{ascii}

where the variance (\mjeqn{var}{ascii}) is calculated across all claims for individual \mjeqn{i}{ascii}.
Then,

\mjdeqn{\hat{p}_c(VarIndIntWAgg) = \sum_{i=1}^N \tilde{w}\_varIndivInterval_{i}B_{i,c}}{ascii}

\strong{KitchSinkWAgg}: Weighted by everything but the kitchen sink

This method is informed by the intuition that we want to reward narrow and asymmetric intervals,
as well as the variability of individuals' interval widths (across their estimates). Again, we multiply
the weights calculated in the \code{"AsymWAgg"}, \code{"IndIntWAgg"} and \code{"VarIndIntWAgg"} methods above.

\mjdeqn{w\_kitchSink_{i,c} = \tilde{w}\_nIndivInterval_{i,c} \cdot \tilde{w}\_asym_{i,c} \cdot \tilde{w}\_varIndivInterval_{i}}{ascii}

\mjdeqn{\hat{p}_c(KitchSinkWAgg) = \sum_{i=1}^N \tilde{w}\_kitchSink_{i,c}B_{i,c}}{ascii}
}
\examples{
\donttest{IntervalWAgg(data_ratings)}

}
