% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpNeeded.R
\name{alpNeeded}
\alias{alpNeeded}
\title{Function to compute alpha needed (fixed sample size)}
\usage{
alpNeeded(N, bta1, thta, tau, lam0, pow = 0.8, ar = 0.5)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{tau}{Expected follow-up time.}

\item{lam0}{Event rate for control.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total)}
}
\value{
The two-sided alpha level.
}
\description{
Function to compute two-sided alpha needed to achieve target power given a rate ratio. Useful for computing probability to achieve hurdles.
}
\details{
This function computes the two-sided alpha alp.
Function assumes a rate ratio < 1 is favourable to treatment.
}
\examples{

# alpha needed to achieve multiple powers given rate ratio (and other input).
alpNeeded(N = 1000, bta1 = log(0.8), thta = 2, tau = 1, lam0 = 1.1, pow = c( .7, .8))

# alpha needed for many inputs
if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(RR = 0.8) \%>\%
    crossing(
      thta = c(2, 3, 4),
      lam0 = 1.1,
      pow = c(0.7, 0.8),
      N = c(500, 1000),
      tau = 1
    ) \%>\%
    mutate(
      alp = alpNeeded(N = N, bta1 = log(RR), thta = thta, tau = tau, lam0 = lam0, pow = pow)
    )
  assumptions \%>\% data.frame()

}


}
