% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/format.R
\docType{methods}
\name{format}
\alias{format}
\alias{format,TimeIntervals-method}
\alias{format,TimeScale-method}
\alias{format,RataDie-method}
\title{Date Conversion to Character}
\usage{
\S4method{format}{TimeIntervals}(x, calendar = get_calendar(), ...)

\S4method{format}{TimeScale}(x, ...)

\S4method{format}{RataDie}(
  x,
  prefix = c("a", "ka", "Ma", "Ga"),
  label = TRUE,
  calendar = get_calendar(),
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{RataDie}} object.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{...}{Currently not used.}

\item{prefix}{A \code{\link{character}} string specifying the prefix.
It should be one of "\code{a}", "\code{ka}", "\code{Ma}" or "\code{Ga}".
If \code{TRUE}, a good guess for an appropriate format is made.}

\item{label}{A \code{\link{logical}} scalar: should the label of the calendar be
displayed?}
}
\value{
A \code{\link{character}} vector representing the date.
}
\description{
Date Conversion to Character
}
\examples{
## R 1.0.0
(y <- fixed(year = 2000, month = 02, day = 29, calendar = CE()))
as_date(y, calendar = CE())
as_year(y, calendar = CE())

## Create a vector of years BP (Gregorian)
## (every two years starting from 2000 BP)
(years <- seq(from = 2000, by = -2, length.out = 10))
## Convert years to rata die
(rd <- fixed(years, calendar = BP()))
## Convert back to Gregorian years BP
as_year(rd, calendar = BP())

## More convenient
(rd <- fixed_from_BP(years))
fixed_to_BP(rd)
}
\seealso{
Other fixed date tools: 
\code{\link{arithmetic}},
\code{\link{as_date}()},
\code{\link{as_decimal}()},
\code{\link{as_fixed}()},
\code{\link{as_year}()},
\code{\link{fixed}()},
\code{\link{fixed_gregorian}},
\code{\link{fixed_julian}},
\code{\link{pretty}()}
}
\author{
N. Frerebeau
}
\concept{fixed date tools}
