% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateSupervisor.R
\name{CreateSupervisor}
\alias{CreateSupervisor}
\title{Creation of a Supervisor for handling regulation in a model}
\usage{
CreateSupervisor(InputsModel, TimeStep = 1L)
}
\arguments{
\item{InputsModel}{[object of type \code{GRiwrmInputsModel}] inputs of the model}

\item{TimeStep}{\link{numeric} number of time steps between each supervision}
}
\value{
A \code{Supervisor} object which is an \link{environment} containing all the necessary variables to run a supervised simulation, such as:
\itemize{
\item \code{DatesR} \link{POSIXct}: vector of date from \code{InputsModel}
\item \code{InputsModel}: a copy of \code{InputsModel} provided by \link{CreateInputsModel.GRiwrm}
\item \code{griwrm}: a copy of \code{griwrm} provided by \link{CreateGRiwrm}
\item \code{Controllers} \link{list}: list of the controllers used in the supervised simulation (See \link{CreateController})
\item some internal state variables updated during simulation (\code{ts.index}, \code{ts.previous}, \code{ts.date}, \code{ts.index0}, \code{controller.id})
}
}
\description{
Creation of a Supervisor for handling regulation in a model
}
\details{
See \link{RunModel.Supervisor} and vignettes for examples of use.
}
\seealso{
\code{\link[=RunModel.Supervisor]{RunModel.Supervisor()}}, \code{\link[=CreateController]{CreateController()}}
}
