% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNodeProperties.R
\name{getNodeProperties}
\alias{getNodeProperties}
\alias{getAllNodesProperties}
\title{Properties of GRiwrm nodes}
\usage{
getNodeProperties(id, griwrm)

getAllNodesProperties(griwrm)
}
\arguments{
\item{id}{\link{character} Id of the node in the GRiwrm object}

\item{griwrm}{[GRiwrm object] describing the network of the semi-distributed model (See \link{CreateGRiwrm})}
}
\value{
\code{getNodeProperties} returns a \link{list} with the following items:
\itemize{
\item "position" (\link{character}): Position of the node in the network ("Upstream" or "Intermediate")
\item "DirectInjection" (\link{logical}): is the node a Direct Injection node?
\item "Diversion" (\link{logical}): is the node a Diversion node?
\item "Reservoir" (\link{logical}): is the node a Reservoir?
\item "airGR" (\link{logical}): is the node contains an airGR model?
\item "calibration" (\link{character}): describe if the node is a "Gauged", or an "Ungauged" station,
(see details), or "NA" otherwise
\item "Upstream" (\link{logical}): is the node an upstream node?
\item "RunOff" (\link{logical}): is the node contains an hydrological model?
}

\code{getAllNodesProperties} returns a \link{data.frame} constituted from the list returned
by \code{getNodeProperties} for all nodes.
}
\description{
\code{getNodeProperties} returns properties of a single node, and
}
\details{
A "Gauged" node is either a node containing a model that is already
calibrated (parameters are already fixed) or a node containing a model where
observations are available for calibration.

A "Ungauged" node is a node containing a model which derives its parameters from
another "donor" node.
}
\examples{
###############################################################################
# Severn network with :                                                       #
# - a Diversion on the node "54001" which transfer flows to the node "540029" #
# - node 54002 as a Direct Injection node                                     #
###############################################################################
data(Severn)
nodes <- Severn$BasinsInfo
nodes$model <- "RunModel_GR4J"
str(nodes)
nodes <- nodes[, c("gauge_id", "downstream_id", "distance_downstream", "model", "area")]
# Add a Diversion node from node "54001" to "54029"
nodes <- rbind(nodes,
               data.frame(
                 gauge_id = "54001",
                 downstream_id = "54029",
                 distance_downstream = 20,
                 model = "Diversion",
                 area = NA
               ))
# Set node '54002' as a Direct Injection node
nodes$model[nodes$id == "54002"] <- NA
# Mismatch column names are renamed to stick with GRiwrm requirements
rename_columns <- list(id = "gauge_id",
                       down = "downstream_id",
                       length = "distance_downstream")
# Create GRiwrm object and display properties
griwrm <- CreateGRiwrm(nodes, rename_columns)

str(getNodeProperties("54001", griwrm))

getAllNodesProperties(griwrm)
}
\seealso{
\code{\link[=CreateGRiwrm]{CreateGRiwrm()}}
}
