% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracelines_poly.R
\name{tracelines_poly}
\alias{tracelines_poly}
\alias{autoplot.tracelinespoly}
\title{Function to plot tracelines from a polytomous IRTmodel}
\usage{
tracelines_poly(model)

\method{autoplot}{tracelinespoly}(
  object,
  xlab = "Theta",
  ylab = "Probability",
  nrow = 2,
  title = "Tracelines",
  ...
)
}
\arguments{
\item{model}{Output from the function \code{pirtmodel}.}

\item{object}{For autoplot: output of tracelines_poly function.}

\item{xlab}{For autoplot: xlabel.}

\item{ylab}{For autoplot: ylabel.}

\item{nrow}{For autoplot: number of rows of heatmaps to plot.}

\item{title}{For autoplot: the title for the plot.}

\item{...}{Other arguments currently ignored.}
}
\value{
Dataframe with output probabilities from the IRT model for all algorithms, an object of
the class  tracelinespoly.
}
\description{
This function makes a dataframe from the polytomous IRTmodel. The autoplot function
can be used to plot trace lines
}
\examples{
data(classification_poly)
mod <- pirtmodel(classification_poly)
obj <- tracelines_poly(mod)
head(obj$df)
autoplot(obj)

}
