% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Client.r
\docType{class}
\name{AlgorithmiaClient-class}
\alias{AlgorithmiaClient-class}
\alias{AlgorithmiaClient}
\title{Client object which makes it easy to interact with the Algorithmia REST API.
To create one, call `getAlgorithmiaClient("YOUR_ALGORITHMIA_API_KEY")`}
\description{
Client object which makes it easy to interact with the Algorithmia REST API.
To create one, call `getAlgorithmiaClient("YOUR_ALGORITHMIA_API_KEY")`
}
\section{Fields}{

\describe{
\item{\code{apiKey}}{The API key used when making REST calls to Algorithmia. This
should NOT be set inside algorithms.}

\item{\code{apiAddress}}{The Algorithmia API address. In most cases you don't need to
set this explicitly since the default will talk to the correct
Algorithmia API server.}
}}

\section{Methods}{

\describe{
\item{\code{algo(algoRef)}}{Takes an algorithm reference  and returns an AlgorithmiaAlgorithm object.
An algorithm reference is a string of the form
[Algorithm Author]/[Algorithm Name]/[Optional Version] like: 'demo/Hello/0.1.1'.
AlgorithmiaAlgorithm objects are used to call algorithms with data.}

\item{\code{dir(dataUrl)}}{Takes a path to a directory and returns a AlgorithmiaDataDirectory object.
Data paths are described in detail at: http://docs.algorithmia.com/?java#data-api-specification.
AlgorithmiaDataDirectory objects are used to interact with directories.}

\item{\code{file(dataUrl)}}{Takes a path to a file and returns a AlgorithmiaDataFile object.
Data paths are described in detail at: http://docs.algorithmia.com/?java#data-api-specification.
AlgorithmiaDataFile objects are used to read and write files.}

\item{\code{reportInsights(insights)}}{Takes a list of Algorithmia Insights and reports them for this algorithm execution.}
}}

