% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alma-step.R
\name{alma_step}
\alias{alma_step}
\title{Step relative to an rschedule}
\usage{
alma_step(x, n, rschedule)
}
\arguments{
\item{x}{\verb{[Date]}

A vector of dates.}

\item{n}{\verb{[integer]}

The number of days to step. Can be negative to step backwards.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule, runion, rintersect, or rsetdiff.}
}
\value{
A Date vector the same size as \code{x} shifted by \code{n} steps.
}
\description{
\code{alma_step()} is useful for shifting dates by "n business days".

\code{alma_step()} steps over a sequence of dates 1 day at a time, for \code{n} days.
After each step, an adjustment is applied to shift to the next non-event
date.
\itemize{
\item If \code{n} is positive, \code{\link[=adj_following]{adj_following()}} is called.
\item If \code{n} is negative, \code{\link[=adj_preceding]{adj_preceding()}} is called.
\item If \code{n} is zero, it was arbitrarily decided to call \code{\link[=adj_following]{adj_following()}} to
roll to the next available non-event date.
}
}
\details{
Imagine you are on a Friday and want to shift forward 2 days using an
rrule that marks weekends as events. \code{alma_step()} works like this:
\itemize{
\item Step forward 1 day to Saturday.
\item Apply an adjustment of \code{\link[=adj_following]{adj_following()}}, which rolls forward to Monday.
\item Step forward 1 day to Tuesday.
\item Apply an adjustment of \code{\link[=adj_following]{adj_following()}}, but no adjustment is required.
}

This lends itself naturally to business logic. Two business days from Friday
is Tuesday.
}
\examples{
# Make a rrule for weekends
on_weekends <- weekly() \%>\%
  recur_on_weekends()

# "Step forward by 2 business days"
# 2019-09-13 is a Friday.
# Here we:
# - Step 1 day to Saturday
# - Adjust to Monday
# - Step 1 day to Tuesday
alma_step("2019-09-13", 2, on_weekends)

# If Monday, 2019-09-16, was a recurring holiday, we could create
# a custom runion and step over that too.
on_09_16 <- yearly() \%>\%
  recur_on_month_of_year(9) \%>\%
  recur_on_day_of_month(16)

rb <- runion(on_09_16, on_weekends)

alma_step("2019-09-13", 2, rb)
}
