% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rset.R
\name{rset}
\alias{rset}
\alias{runion}
\alias{rintersect}
\alias{rsetdiff}
\title{Create a new set-based recurrence schedule}
\usage{
runion(...)

rintersect(...)

rsetdiff(...)
}
\arguments{
\item{...}{\verb{[rschedules]}

rschedule objects to add to the set.}
}
\value{
A runion, rintersect, or rsetdiff.
}
\description{
Often, a single rrule will be sufficient. However, more complex
recurrence objects can be constructed by combining multiple rschedules into
a \emph{recurrence set}.

There are three types of recurrence sets provided in almanac, each of
which construct their event sets by performing a set operation on the
underlying events of the rschedules in the set.
\itemize{
\item \code{runion()} takes the union.
\item \code{rintersect()} takes the intersection.
\item \code{rsetdiff()} takes the set difference.
}
}
\details{
For \code{rsetdiff()}, the event set is created "from left to right" and depends
on the order that the rschedules were added to the set.
}
\examples{
since <- "2019-04-01"
until <- "2019-05-31"

on_weekends <- weekly(since = since, until = until) \%>\%
  recur_on_weekends()

on_25th <- monthly(since = since, until = until) \%>\%
  recur_on_day_of_month(25)

# On weekends OR the 25th of the month
ru <- runion(on_weekends, on_25th)
alma_events(ru)

# On weekends AND the 25th of the month
ri <- rintersect(on_weekends, on_25th)
alma_events(ri)

# On weekends AND NOT the 25th of the month
rsd1 <- rsetdiff(on_weekends, on_25th)
alma_events(rsd1)

# On the 25th of the month AND NOT the weekend
rsd2 <- rsetdiff(on_25th, on_weekends)
alma_events(rsd2)
}
