% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLocation.R
\name{extractLocation}
\alias{extractLocation}
\title{Extract location from coordinate request}
\usage{
extractLocation(res, details = NULL)
}
\arguments{
\item{res}{Required.
Response object returned by [getLocation()] with `output = "JSON"` or by the
AutoNavi reverse-geocoding API.}

\item{details}{Optional.
Character vector describing which extended detail payloads to parse into
list-columns. Valid values are `"pois"`, `"roads"`, `"roadinters"`, and
`"aois"`. Use `"all"` to include every detail payload.}
}
\value{
A `tibble` describing the parsed reverse-geocode results. Each row
corresponds to an element in the API response. When no data is present a
single placeholder row filled with `NA` values is returned.
}
\description{
Extract location from coordinate request
}
\examples{
\dontrun{
raw <- getLocation(104.043284, 30.666864, output = "JSON")
extractLocation(raw, details = c("pois", "roads"))
}

}
\seealso{
[getLocation()]
}
