% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hdash.R
\name{Hdash}
\alias{Hdash}
\title{Calculates H' the Shannon diversity index}
\usage{
Hdash(
  df,
  by = NULL,
  var_species = "species",
  var_count = "count",
  check_species = TRUE,
  df_species = NULL
)
}
\arguments{
\item{df}{a dataframe of species observations}

\item{by}{a vector of column names found in \code{df} by which calculations
should be grouped \emph{e.g. c("station","date")}}

\item{var_species}{name of the column in \code{df} containing species names}

\item{var_count}{name of the column in \code{df} containing count/density/abundance}

\item{check_species}{boolean, default = TRUE. If TRUE, then only species found
in the species list are included in \emph{H'} index. By default,
the AZTI species list is used.}

\item{df_species}{\emph{optional} dataframe with user-specified species list.}
}
\value{
a list of two dataframes:
\itemize{
\item \code{H} : results of the AMBI index calculations. For each unique
combination of \code{by}variables the following values are calculated:
\itemize{
\item \code{H} : the Shannon diversity Index, \emph{H'}
\item \code{S} : the number of species
\item \code{N} : the number of individuals
}
\item \code{match} : the original dataframe with columns added from the species list.
For a user-specified list provided \code{df_species}, all columns will be included.
If the user-specified species list contains only a single column with species
names, then a new column \code{match} will be created, with a value of \code{1} indicating
a match and an \code{NA} value where no match was found.
}

For the default AZTI species list the following additional columns will be
included:
\itemize{
\item \code{group} : showing the AMBI species group
\item \code{RA} : indicating that the species is \emph{reallocatable} according to the
AZTI list. That is, it could be re-assigned to a different species group.
}
}
\description{
\code{\link[=Hdash]{Hdash()}} matches a list of species counts with the AMBI species list
and calculates \emph{H'} the Shannon diversity index.
\href{#references}{(Shannon, 1948)}
}
\details{
If the function is called with the argument \code{check_species = TRUE} then
only species which are successfully matched with the specified species
list are included in the calculations. This is the default. If the function
is called with \code{check_species = FALSE}then all rows are counted.
}
\examples{

Hdash(test_data, by=c("station"))

}
\references{
Shannon, C. E. (1948) "A mathematical theory of communication," in \emph{The Bell System Technical Journal}, vol. 27, no. 3, pp. 379-423.
\doi{doi:10.1002/j.1538-7305.1948.tb01338.x}
}
