% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{multidna2alignment}
\alias{multidna2alignment}
\alias{multiphyDat2alignment}
\title{Convert from multidna into alignment (seqinr)}
\usage{
multidna2alignment(x, genes = TRUE)

multiphyDat2alignment(x, genes = TRUE)
}
\arguments{
\item{x}{a \linkS4class{multidna} or \linkS4class{multiphyDat} object.}

\item{genes}{an optional vector indicating the genes to retain for the concatenation; any way to subset the list in x@dna or x@seq is acceptable; by default, all genes are used.}
}
\value{
a alignment object
}
\description{
The functions \code{multidna2alignment} and \code{multiphyDat2alignment} concatenates separate sequences and return an alignment object of the seqinr package.
}
\examples{
## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
y <- multidna2alignment(x)
y
x2 <- multidna2multiphyDat(x)
z <- multiphyDat2alignment(x2)
}
\seealso{
\itemize{
\item concatenate
\item \code{\link[ape]{as.alignment}} to convert single DNAbin objects.
}
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}, Zhian N. Kamvar, Klaus Schliep
}
