% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_apply.R
\name{cov_apply}
\alias{cov_apply}
\title{Apply covariates to PK(PD) dataset}
\usage{
cov_apply(
  df,
  cov,
  id.by = "USUBJID",
  time.by = NA,
  direction = "downup",
  exp = FALSE,
  ebe = FALSE,
  cov.rnd = NA,
  na = -999,
  demo.map = TRUE,
  keep.other = TRUE
)
}
\arguments{
\item{df}{PK(PD) dataframe generated by pk_build}

\item{cov}{dataframe of covariates}

\item{id.by}{id variable to merge covariates}

\item{time.by}{time variable to merge covariates}

\item{direction}{fill direction for time-varying covariates}

\item{exp}{treats new covariates as exposure metrics when TRUE}

\item{ebe}{treats new covariates as empirical bayes estimates when TRUE}

\item{cov.rnd}{covariate rounding parameter}

\item{na}{value to replace NA numeric covariates}

\item{demo.map}{toggle pre-set numeric values for SEX, RACE, and ETHNIC demographic variables}

\item{keep.other}{filter to keep or remove other events, EVID = 2}
}
\value{
PK(PD) dataset with additional covariates]
}
\description{
Add covariates to a dataset built by pk_build() or pk_combine()
Can add subject-level covariates (by any ID variable) or time-varying (by any time variable)
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create with pk_build()
df <- pk_build(ex, pc)

## Simple dm domain for the corresponding study
dm <- data.frame(USUBJID = c("ABC101-001",
                             "ABC101-002",
                             "ABC101-003"),
                 AGE = c(45,
                         37,
                         73),
                 AGEU = "years",
                 SEX = c("Male",
                         "Female",
                         "Male"),
                 RACE = c("White",
                          "White",
                          "Black"),
                 ETHNIC = c("Not Hispanic/Latino",
                            "Not Hispanic/Latino",
                            "Not Hispanic/Latino"))

## Add covariates with cov_apply()
df1 <- cov_apply(df, dm)

}
