% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_runner.R
\name{run_appraise_model}
\alias{run_appraise_model}
\title{Run the appraise Stan model}
\usage{
run_appraise_model(
  bias_spec,
  yhat,
  stdev,
  threshold_value,
  iter_sampling = 5000,
  iter_warmup = 1000,
  chains = 4,
  seed = 12345
)
}
\arguments{
\item{bias_spec}{Output from build_bias_specification()}

\item{yhat}{Reported point estimate}

\item{stdev}{Reported standard error}

\item{threshold_value}{Threshold for significance}

\item{iter_sampling}{Number of sampling iterations}

\item{iter_warmup}{Number of warmup iterations}

\item{chains}{Number of MCMC chains}

\item{seed}{Random seed}
}
\value{
A list containing the CmdStan fit object and posterior draws
}
\description{
Executes the posterior mixture model described in Kabali (2025)
}
\examples{
# Define a simple bias specification with one bias
bias_spec <- build_bias_specification(
  num_biases = 1,
  b_types = "Confounding",
  ab_params = list(
    Confounding = c(2, 5)
  )
)

bias_spec

\donttest{
# Run the AppRaise model for a single study. Requires cmdstanr and a CmdStan
# installation.
fit <- run_appraise_model(
  bias_spec = bias_spec,
  yhat = -0.6,
  stdev = 0.12,
  threshold_value = -0.4,
  iter_sampling = 500,
  iter_warmup = 250,
  chains = 2,
  seed = 123
)

# Posterior draws of the causal effect
head(fit$theta)

# Posterior probability of exceeding the threshold
posterior_probability(fit$mid)

# Posterior summary
posterior_summary(fit$theta)
}
}
\references{
Kabali C (2025). AppRaise: Software for quantifying evidence uncertainty
in systematic reviews using a posterior mixture model. \emph{Journal of
Evaluation in Clinical Practice}, 31, 1-12. https://doi.org/10.1111/jep.70272.
}
\seealso{
\itemize{
\item \code{\link{build_bias_specification}}
\item \code{\link{posterior_probability}}
\item \code{\link{posterior_summary}}
\item \code{vignette("appraise-introduction")}
}
}
