% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nutrient_use_efficiency.R
\name{nr}
\alias{nr}
\title{Nutrient retention (NR)}
\usage{
nr(ibw, fbw, ibn, fbn, fi, nut_f, dm = 1, dm_ib = 1, dm_fb = 1)
}
\arguments{
\item{ibw}{numeric; initial weight in grams}

\item{fbw}{numeric; final weight in grams}

\item{ibn}{numeric; initial mass fraction of the target nutrient in the 
tissue of the experimental animal (on dry matter basis). The value must be 
between 0 and 1.}

\item{fbn}{numeric; final mass fraction of the target nutrient in the tissue
of the experimental animal (on dry matter basis). The value must be between 
0 and 1.}

\item{fi}{numeric; mass of feed given.}

\item{nut_f}{numeric; mass fraction of nutrient in the diet. The value 
must be between 0 and 1.}

\item{dm}{numeric; dry matter content of feed. Default is 1.}

\item{dm_ib}{numeric; initial dry matter content of body tissue. Default is 
1.}

\item{dm_fb}{numeric; final dry matter content of body tissue. Default is 1.}
}
\value{
a numeric value. Multiply by 100 to convert into percentage.
}
\description{
Function to calculate the Nutrient Retention (NR). The NR 
belongs to the Nutrient Use Efficiency metrics and is a measure for the 
proportion of a consumed nutrient that is retained in the tissue.
}
\examples{
# initial bodyweight = 10 g (0.01 kg)
# final bodyweight = 100 g (0.1 kg)
# initial mass fraction of N = 128 g/kg (80\% CP on DM basis)
# final mass fraction of N = 132 g/kg (82.5\% CP on DM basis)
# feed intake = 200 g (0.2 kg)
# N in feed = 72 g/kg (45\% CP)

nr(10, 100, 0.128, 0.132, 200, 0.072) * 100

# 82.7\% of the provided N has been retained


# multiple fish
nr(ibw = 10, fbw = c(93, 102, 99, 98, 101, 132),
   ibn = 0.128, fbn = 0.132,
   fi = 200, nut_f = 0.072)

}
\references{
Willer, D.F., Newton, R., Malcorps, W. et al. Wild fish
consumption can balance nutrient retention in farmed fish. Nat Food 5,
221–229 (2024). https://doi.org/10.1038/s43016-024-00932-z
}
\author{
Anıl Axel Tellbüscher
}
