% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{taxonomy}
\alias{taxonomy}
\title{Get taxonomy from species.}
\usage{
taxonomy(tax, check = FALSE, aut = FALSE, id = FALSE, order = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{check}{species names should be replaced by possible matches in the WSC if outdated.}

\item{aut}{add species authorities.}

\item{id}{the lsid should be returned.}

\item{order}{Order taxa names alphabetically or keep as in tax.}
}
\value{
A data.frame with species and taxonomy.
}
\description{
Get species sub/infraorder, family and genus from the World Spider Catalogue.
}
\details{
This function will get species sub/infraorder, family and genus from the World Spider Catalogue (2025). Optionally, it will correct the species names (using function checknames) and provide the lsid and authors from the WSC (using functions lsid and authors).
}
\examples{
\dontrun{
taxonomy("Symphytognathidae", order = TRUE, aut = TRUE)
taxonomy(c("Nemesia machadoi", "Nemesia bacelari"), check = TRUE, aut = TRUE, id = TRUE)
}
}
\references{
World Spider Catalog (2025). World Spider Catalog. Version 26. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
