% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharing.R
\name{arc_group}
\alias{arc_group}
\title{Fetch Group Information}
\usage{
arc_group(group_id, host = arc_host(), token = arc_token())
}
\arguments{
\item{group_id}{the unique group identifier. A scalar character.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
a list with group metadata
}
\description{
Fetches metadata about a group based on a provided \code{group_id}.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
arc_group("2f0ec8cb03574128bd673cefab106f39")
\dontshow{\}) # examplesIf}
}
\seealso{
Other portal organization: 
\code{\link{arc_user}()}
}
\concept{portal organization}
