% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTagsRepo.R
\name{removeTagsRepo}
\alias{removeTagsRepo}
\title{Remove Tags from Repository}
\usage{
removeTagsRepo(md5hashes, repoDir = NULL, tags = NULL)
}
\arguments{
\item{md5hashes}{a character vector of \code{md5hashes} specifying to which
corresponding artifacts \code{Tags} should be removes}

\item{repoDir}{A character that specifies the directory of the Repository to which
new \code{Tags} will be added. If it is set to \code{NULL} (by default),
it uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{tags}{A character vector which specifies what Tags should be removed.}
}
\description{
\code{removeTagsRepo} removes selected \link{Tags} from selected objects in \link{Repository}.
}
\details{
\code{removeTagsRepo} function removes all Tags from all listed objects.
Note that some hashes are required for keeping relations between objects in the repository.
Be careful what are you removing.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{
# Creating empty repository
exampleRepoDir <- tempfile()
createLocalRepo(exampleRepoDir, force=TRUE)

# Saving lm artifacts into repository
m1 <- lm(Sepal.Length~Species, iris)
saveToLocalRepo(m1, exampleRepoDir)

# We may see what kind of Tags are related to "m1" artifact corresponding to
getTagsLocal("9e66edd297c2f291446f3503c01d443a", exampleRepoDir, "")

# One more look at our Repo
removeTagsRepo("9e66edd297c2f291446f3503c01d443a", exampleRepoDir, tags = "rank:3")

# Deleting example repository
deleteLocalRepo(exampleRepoDir, deleteRoot=TRUE)
rm(exampleRepoDir)
}

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addHooksToPrint}()},
\code{\link{addTagsRepo}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{aoptions}()},
\code{\link{archivistPackage}},
\code{\link{aread}()},
\code{\link{areadLocal}()},
\code{\link{asearch}()},
\code{\link{asearchLocal}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{createMDGallery}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{shinySearchInLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
