% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.r
\name{da_read}
\alias{da_read}
\title{Read Table with arcpy.da}
\usage{
da_read(table.path, fields, simplify = TRUE)
}
\arguments{
\item{table.path}{The file path to the table.}

\item{fields}{A vector of field names or column indices to retrieve.}

\item{simplify}{If \code{TRUE}, coerce the results to a data.frame. If
\code{FALSE}, the results will be returned as a list of lists, with
each top-level element corresponding to one row of the table.}
}
\value{
a dataframe with columns corresponding to \code{fields}.
}
\description{
Read a table (e.g. attribute table of a layer) with the
\code{arcpy.da} module.
}
\details{
This implementation may be faster than accessing the
\verb{@data} slot of an object created from \code{rgdal::readOGR}
in cases where there are a very large number of features. An
additional advantage of \code{da_read} is that it can read
raster attribute tables and stand-alone tables stored in file
geodatabases, which is not supported by \code{rgdal::readOGR}.
}
\examples{
\dontrun{
arcpy$env$workspace = tempdir()
arcpy$env$scratchWorkspace = tempdir()
fc = arcpy$management$CopyFeatures(system.file("CA_Counties",
  "CA_Counties_TIGER2016.shp", package = "arcpy"), "CA_Counties")
da_read(fc, c("COUNTYFP", "ALAND"))
}

}
