% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRelevance.R
\name{plotRelevance}
\alias{plotRelevance}
\title{Relevance plot for asmbPLS-DA}
\usage{
plotRelevance(fit.results, n.top = 10, ncomp = 1, block.name = NULL)
}
\arguments{
\item{fit.results}{The output of \code{\link[asmbPLS]{asmbPLSDA.fit}} or 
\code{\link[asmbPLS]{asmbPLS.fit}}.}

\item{n.top}{A integer indicating the number of the most relevant features to 
be displayed for each block. The default is 10. If the number of selected 
features in the block is smaller than \code{n.top}, all the selected features in
that block will be displayed.}

\item{ncomp}{Which component to plot from each block. Should not be larger 
than the number of PLS components used (\code{PLS.comp}) in the function
\code{\link[asmbPLS]{asmbPLSDA.fit}} or \code{\link[asmbPLS]{asmbPLS.fit}}. 
The default is 1.}

\item{block.name}{A vector containing the named character for each block. It
must be ordered and match each block.}
}
\value{
none
}
\description{
Function to visualize the most relevant features (relevant to the outcome) in 
each block.
}
\details{
The function returns a plot to show the most relevant features for each 
block.
}
\examples{
## Use the example dataset
data(asmbPLSDA.example)
X.matrix = asmbPLSDA.example$X.matrix
Y.matrix.binary = asmbPLSDA.example$Y.matrix.binary
Y.matrix.multiclass = asmbPLSDA.example$Y.matrix.morethan2levels
X.dim = asmbPLSDA.example$X.dim
PLS.comp = asmbPLSDA.example$PLS.comp
quantile.comb = asmbPLSDA.example$quantile.comb
 
## asmbPLSDA fit for binary outcome
asmbPLSDA.fit.binary <- asmbPLSDA.fit(X.matrix = X.matrix, 
                                      Y.matrix = Y.matrix.binary, 
                                      PLS.comp = PLS.comp, 
                                      X.dim = X.dim, 
                                      quantile.comb = quantile.comb,
                                      outcome.type = "binary")

## asmbPLSDA fit for categorical outcome with more than 2 levels
asmbPLSDA.fit.multiclass <- asmbPLSDA.fit(X.matrix = X.matrix, 
                                          Y.matrix = Y.matrix.multiclass,
                                          PLS.comp = PLS.comp, 
                                          X.dim = X.dim, 
                                          quantile.comb = quantile.comb,
                                          outcome.type = "multiclass")

## visualization to show the most relevant features in each block
plotRelevance(asmbPLSDA.fit.binary)
plotRelevance(asmbPLSDA.fit.multiclass)
## custom n.top and block.name
plotRelevance(asmbPLSDA.fit.binary, 
              n.top = 5,
              block.name = c("mRNA", "protein"))
plotRelevance(asmbPLSDA.fit.multiclass, 
              n.top = 7,
              block.name = c("miRNA", "protein"))


}
