% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_init.R
\name{check_init}
\alias{check_init}
\title{Check and initialize a vector}
\usage{
check_init(x)
}
\arguments{
\item{x}{A numeric vector with named elements.}
}
\value{
If successful there is no message, otherwise, it issues warnings with
informative messages for each failed condition.
}
\description{
This function checks a given vector for several conditions, including values being
within the range 0 to 1 inclusive and the sum of values being equal to 1. If the vector
is named, the function checks all elements have names and no names are duplicates.
}
\examples{
x <- setNames(object = c(0.2, 0.3, 0.4, 0.1), nm = letters[1:4])
check_init(x) # x is a valid input, no warnings issued

x <- setNames(c(0.2, 0.3, 0.4, 0.1), nm = c("H", NA, "NA", "D"))
check_init(x) # Should issue a warning about missing names

x <- c(-2, 0.3, 0.4, 0.1)
check_init(x) # Should issue a warning about a value below 0 and about not summing to 1

}
