% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheers_checker.R
\name{find_folder_function_definitions}
\alias{find_folder_function_definitions}
\title{Creates summary of R files in folder with functions defined within and locations.}
\usage{
find_folder_function_definitions(
  foo_folder = ".",
  f_excl = NULL,
  d_excl = NULL
)
}
\arguments{
\item{foo_folder}{A folder to apply find_function_definitions to each script in.}

\item{f_excl}{A regular expression for files to NOT process (basename)}

\item{d_excl}{A regular expression for directories to NOT process (dirname)}
}
\value{
A dataframe containing a column for function string and a column for function location.
}
\description{
Applies find_function_definitions to each file in a folder and aggregate results
}
\examples{
# Skip listed files "somefile.R", and "another_file.R"
folder_path <- assertHE_example("example_project")
find_folder_function_definitions(
   foo_folder = folder_path,
   f_excl = "\\\\b(somefile\\\\.R|another_file\\\\.R)\\\\b"
)

}
