% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_files.R
\name{assert_all_files_have_extension}
\alias{assert_all_files_have_extension}
\title{Assert file extensions}
\usage{
assert_all_files_have_extension(
  x,
  extensions,
  compression = FALSE,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{extensions}{valid extensions (character vector). Do not include the '.', e.g. supply \code{extensions = 'txt'} not \code{extensions = '.txt'}}

\item{compression}{should compression extension ‘.gz’, ‘.bz2’ or ‘.xz’ be removed first?}

\item{msg}{A character string containing the error message if file \code{x} does not have the specified extensions}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} has any of the specified extensions, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that all filepaths supplied have one of the selected extensions. Does not require file to actually exist.
}
\examples{
try({
assert_all_files_have_extension(c("foo.txt", "bar.txt"), extensions = "txt") # Passes
assert_all_files_have_extension(c("foo.txt", "bar.csv"), extensions = "csv") # Throws Error
})

}
\concept{assert_file}
