% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.R
\name{assert_class}
\alias{assert_class}
\title{Assert object belongs to class}
\usage{
assert_class(x, class, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An input object}

\item{class}{checks if \code{x} belongs to \code{class}. If multiple values of \code{class} are supplied, returns whether \code{x} belongs to any of them (character)}

\item{msg}{A character string containing the error message to display if \code{x} does not belong to \code{class}}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} belongs to \code{class}, otherwise aborts with the error message specified by \code{msg}
}
\description{
This function asserts that the input object belongs to \code{class}
}
\examples{
try({
assert_has_class(1, "numeric")  # Passes
assert_has_class(1, "character")  # Throws default error
})

}
\concept{assert_has}
