% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wald_pvalues.R
\name{plot_ecdf_pvalue}
\alias{plot_ecdf_pvalue}
\title{Plot Empirical Cumulative Distribution Function (ECDF) of p-values}
\usage{
plot_ecdf_pvalue(
  p_values,
  ks_test = TRUE,
  signif = c(0.01, 0.05, 0.1),
  discrepancy_tol = 0.1,
  plot_uniform = TRUE,
  uniform_legend = TRUE,
  main = "",
  ylab = "Empirical cumulative distribution",
  xlab = "p-value",
  ...
)
}
\arguments{
\item{p_values}{vector of p-values}

\item{ks_test}{If \code{TRUE} inserts Kolmogorov-Smirnov p-value in the graphic.}

\item{signif}{Points to verify discrepancy.}

\item{discrepancy_tol}{Threshold to consider point discrepant.}

\item{plot_uniform}{Logical. If TRUE, plot uniform distribution.}

\item{uniform_legend}{Logical. If TRUE, a legend is added to the plot to
distinguish between the p-value and U(0, 1) curves. Defaults to TRUE.}

\item{main}{main caption passed to \link{plot}}

\item{ylab}{The label for the y-axis. Defaults to "Empirical cumulative distribution".}

\item{xlab}{The label for the x-axis. Defaults to "p-value".}

\item{...}{extra arguments passed to \link[graphics:plot.default]{graphics::plot}}
}
\value{
No return value, called for side effects
}
\description{
Plot Empirical Cumulative Distribution Function (ECDF) of p-values
}
