% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{binary_cross_entropy}
\alias{binary_cross_entropy}
\title{Estimates the inverse binary cross-entropy, i.e. 0 is the best score and 1
the worst.}
\usage{
binary_cross_entropy(
  pred,
  data.valid,
  loss.unit = c("individuals", "L2 units"),
  y,
  L2.unit
)
}
\arguments{
\item{pred}{Predictions of outcome. A numeric vector of outcome predictions.}

\item{data.valid}{Test data set. A tibble of data that was not used for
prediction.}

\item{loss.unit}{Loss function unit. A character-valued scalar indicating
whether performance loss should be evaluated at the level of individual
respondents (\code{individuals}) or geographic units (\code{L2 units}).
Default is \code{individuals}.}

\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable.}

\item{L2.unit}{Geographic unit. A character scalar containing the column name
of the geographic unit in \code{survey} and \code{census} at which outcomes
should be aggregated.}
}
\value{
Returns a tibble containing two binary cross-entropy prediction
  errors. The first is measured at the level of individuals and the second is
  measured at the context level. The tibble dimensions are 2x3 with
  variables: measure, value and level.
}
\description{
\code{binary_cross_entropy()} estimates the inverse binary cross-entropy on
the individual and state-level.
}
