% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-AutomatedTest.R
\name{AutomatedTest}
\alias{AutomatedTest}
\title{AutomatedTest class}
\description{
The AutomatedTest class represents a result of a statistical test. It contains attributes such as the p-value, degrees of freedom, and more.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AutomatedTest-new}{\code{AutomatedTest$new()}}
\item \href{#method-AutomatedTest-get_data}{\code{AutomatedTest$get_data()}}
\item \href{#method-AutomatedTest-is_paired}{\code{AutomatedTest$is_paired()}}
\item \href{#method-AutomatedTest-get_identifiers}{\code{AutomatedTest$get_identifiers()}}
\item \href{#method-AutomatedTest-get_compare_to}{\code{AutomatedTest$get_compare_to()}}
\item \href{#method-AutomatedTest-set_compare_co}{\code{AutomatedTest$set_compare_co()}}
\item \href{#method-AutomatedTest-get_datatypes}{\code{AutomatedTest$get_datatypes()}}
\item \href{#method-AutomatedTest-get_parametric_list}{\code{AutomatedTest$get_parametric_list()}}
\item \href{#method-AutomatedTest-is_parametric}{\code{AutomatedTest$is_parametric()}}
\item \href{#method-AutomatedTest-get_test}{\code{AutomatedTest$get_test()}}
\item \href{#method-AutomatedTest-get_result}{\code{AutomatedTest$get_result()}}
\item \href{#method-AutomatedTest-get_strength}{\code{AutomatedTest$get_strength()}}
\item \href{#method-AutomatedTest-is_significant}{\code{AutomatedTest$is_significant()}}
\item \href{#method-AutomatedTest-print}{\code{AutomatedTest$print()}}
\item \href{#method-AutomatedTest-clone}{\code{AutomatedTest$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-new"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-new}{}}}
\subsection{Method \code{new()}}{
Initialize an instance of the AutomatedTest class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$new(data, identifiers, compare_to = NULL, paired = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A dataframe containing the data for the test.}

\item{\code{identifiers}}{A vector with the identifiers.}

\item{\code{compare_to}}{Numeric value to compare to for comparison in one-sample tests. Default is NULL.}

\item{\code{paired}}{Logical; if TRUE, the test will be performed as paired if applicable. Default is FALSE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_data}{}}}
\subsection{Method \code{get_data()}}{
Get the data used in the test
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A dataframe with all features
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-is_paired"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-is_paired}{}}}
\subsection{Method \code{is_paired()}}{
Shows if the data is paired, if there are multiple rows with the same identifier, the data has more
samples (TIDY DATA). Making the data paired.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$is_paired()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Whether the data is paired (TRUE/FALSE).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_identifiers"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_identifiers}{}}}
\subsection{Method \code{get_identifiers()}}{
A list of the identifiers used for the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_identifiers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the identifiers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_compare_to"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_compare_to}{}}}
\subsection{Method \code{get_compare_to()}}{
Get the comparison value for one-sample tests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_compare_to()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric value for comparison
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-set_compare_co"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-set_compare_co}{}}}
\subsection{Method \code{set_compare_co()}}{
Updates the compare_to variable. Is public because the
compare value can get changed depending on the type of test. This
function is public because it needs to be able to be called by
automatical_test()
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$set_compare_co(compare_to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compare_to}}{Numeric value to compare to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated object with comparison value set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_datatypes"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_datatypes}{}}}
\subsection{Method \code{get_datatypes()}}{
Get the data types of the features in the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_datatypes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of data types (e.g., Quantitative or Qualitative)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_parametric_list"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_parametric_list}{}}}
\subsection{Method \code{get_parametric_list()}}{
Get the parametric test results of the features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_parametric_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of parametric test results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-is_parametric"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-is_parametric}{}}}
\subsection{Method \code{is_parametric()}}{
Check if the data meets parametric assumptions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$is_parametric()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if parametric assumptions are met, otherwise FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_test"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_test}{}}}
\subsection{Method \code{get_test()}}{
Get the statistical test that was chosen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_test()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the statistical test
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_result"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_result}{}}}
\subsection{Method \code{get_result()}}{
Get the result of selected statistical test
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_result()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The result of the statistical test
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-get_strength"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-get_strength}{}}}
\subsection{Method \code{get_strength()}}{
Get the strength(s) of selected statistical test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$get_strength()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named numeric value indicating the strength of the result.
The type and meaning depend on the test used:
\describe{
  \item{coefficient}{Effect size and direction of predictors in regression}
  \item{r}{Correlation strength and direction}
  \item{mean difference}{Difference in group means}
  \item{statistic}{Test statistic measuring group difference or association}
  \item{F statistic}{Ratio of variances across groups}
  \item{proportion}{Estimated success rate in the sample}
  \item{non-existent}{No interpretable strength measure available}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-is_significant"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-is_significant}{}}}
\subsection{Method \code{is_significant()}}{
Whether the test results are significant or not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$is_significant()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE / FALSE depending on the significance of the test.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-print"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the test object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutomatedTest-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AutomatedTest-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutomatedTest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
