% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamplingVAE.R
\name{encoder_latent}
\alias{encoder_latent}
\title{Rebuild the encoder graph to export z_mean and z_log_var}
\usage{
encoder_latent(
  encoder_input,
  encoder_info,
  latent_dim,
  Lip_en,
  power_iterations
)
}
\arguments{
\item{encoder_input}{Data frame or matrix of the \strong{preprocessed} variables (used for shape only).}

\item{encoder_info}{List defining encoder architecture.}

\item{latent_dim}{Integer. Latent dimension.}

\item{Lip_en}{Integer (0/1). Whether spectral normalization was used in the encoder.}

\item{power_iterations}{Integer. Power iterations for spectral normalization (if used).}
}
\value{
A Keras model whose outputs are \code{list(z_mean, z_log_var)}.
}
\description{
Constructs the encoder computation graph (matching your original \code{encoder_info})
so that weights extracted by \code{\link[=Encoder_weights]{Encoder_weights()}} can be applied and the encoder
to produce \code{z_mean} and \code{z_log_var}.
}
\details{
\itemize{
\item Spectral normalization is sourced from TensorFlow Addons via \code{\link[=get_tfa]{get_tfa()}}.
\item \code{encoder_input} provides shape; the data are not consumed at build time.
\item Apply weights with \code{set_weights()} using the output of \code{\link[=Encoder_weights]{Encoder_weights()}}.
}
}
\examples{
encoder_info <- list(
  list("dense", 100, "relu"),
  list("dense",  80, "relu")
)
\donttest{
if (reticulate::py_module_available("tensorflow") &&
    exists("training")) {
weights_encoder <- Encoder_weights(
  encoder_layers = 2,
  trained_model  = training$trained_model,  #where training = VAE_train(...)
  lip_enc        = 0,
  pi_enc         = 0,
  BNenc_layers   = 0,
  learn_BN       = 0
)

latent_encoder <- encoder_latent(
  encoder_input    = data,
  encoder_info     = encoder_info,
  latent_dim       = 5,
  Lip_en           = 0,
  power_iterations = 0
)
latent_encoder \%>\% keras::set_weights(weights_encoder)
}
}

}
\seealso{
\code{\link[=Encoder_weights]{Encoder_weights()}}, \code{\link[=Latent_sample]{Latent_sample()}}, \code{\link[=Decoder_weights]{Decoder_weights()}}
}
