% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/passwords.R
\name{change_pwd}
\alias{change_pwd}
\alias{get_pwd_policy}
\alias{set_pwd_policy}
\title{Change Password}
\usage{
change_pwd(old, new, ...)

get_pwd_policy(...)

set_pwd_policy(
  allowchange,
  hardexpire,
  age,
  length,
  previous,
  requirements,
  ...
)
}
\arguments{
\item{old}{A character string specifying the current password}

\item{new}{A character string specifying the new password}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{allowchange}{Optionally, a logical indicating whether to allow users to change their own passwords (default is \code{FALSE}).}

\item{hardexpire}{Optionally, a logical indicating whether to prevent users from changing their passwords after they expire (default is \code{FALSE}).}

\item{age}{Optionally, a number of days (between 1 and 1095) specifying maximum valid age of an IAM user password.}

\item{length}{Optionally, a minimum password length between 6 and 128 (default is 6).}

\item{previous}{Optionally, a number specifying the number (between 1 and 24) of previous passwords that users are prevented from reusing. Default is 0.}

\item{requirements}{A character vector specifying whether to require specific password features, including: \dQuote{upper} (upper case character), \dQuote{lower} (lower case character), \dQuote{number} (a digit), and \dQuote{symbol} (a symbol). Multiple can be specified.}
}
\value{
\code{get_pwd_policy} returns a list. \code{change_pwd} and \code{set_pwd_policy} return a logical \code{TRUE} (if successful).
}
\description{
Change password for currently authenticated user
}
\references{
\href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html}{IAM Password Policies}
}
