% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_credentials.R
\name{locate_credentials}
\alias{locate_credentials}
\title{Locate AWS Credentials}
\usage{
locate_credentials(
  key = NULL,
  secret = NULL,
  session_token = NULL,
  region = NULL,
  file = Sys.getenv("AWS_SHARED_CREDENTIALS_FILE", default_credentials_file()),
  profile = NULL,
  default_region = getOption("cloudyr.aws.default_region", "us-east-1"),
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{key}{An AWS Access Key ID}

\item{secret}{An AWS Secret Access Key}

\item{session_token}{Optionally, an AWS Security Token Service (STS) temporary Session Token}

\item{region}{A character string containing the AWS region for the request. If missing, \dQuote{us-east-1} is assumed.}

\item{file}{A character string containing a path to a centralized \samp{.aws/credentials} file.}

\item{profile}{A character string specifying which profile to use from the file. By default, the profile named in \env{AWS_PROFILE} is used, otherwise the \dQuote{default} profile is used.}

\item{default_region}{A character string specifying a default string to use of no user-supplied value is found.}

\item{verbose}{A logical indicating whether to be verbose.}
}
\description{
Locate AWS credentials from likely sources
}
\details{
These functions locate values of AWS credentials (access key, secret access key, session token, and region) from likely sources. The order in which these are searched is as follows:
\enumerate{
  \item user-supplied values passed to the function
  \item environment variables (\env{AWS_ACCESS_KEY_ID}, \env{AWS_SECRET_ACCESS_KEY}, \env{AWS_DEFAULT_REGION}, and \env{AWS_SESSION_TOKEN})
  \item an instance role (on the running ECS task from which this function is called) as identified by \code{\link[aws.ec2metadata]{metadata}}, if the aws.ec2metadata package is installed
  \item an IAM instance role (on the running EC2 instance from which this function is called) as identified by \code{\link[aws.ec2metadata]{metadata}}, if the aws.ec2metadata package is installed
  \item a profile in a local credentials dot file in the current working directory, using the profile specified by \env{AWS_PROFILE}
  \item the default profile in that local credentials file
  \item a profile in a global credentials dot file in a location set by \env{AWS_SHARED_CREDENTIALS_FILE} or defaulting typically to \file{~/.aws/credentials} (or another OS-specific location), using the profile specified by \env{AWS_PROFILE}
  \item the default profile in that global credentials file
}

If \env{AWS_ACCESS_KEY_ID} and \env{AWS_SECRET_ACCESS_KEY} environment variables are not present when the package is loaded, then \code{use_credentials} is invoked using the file specified in \env{AWS_SHARED_CREDENTIALS_FILE} (or another default location) and the profile specified in \env{AWS_PROFILE} (or, if missing, the \dQuote{default} profile).

To use this (and any cloudyr package) on AWS EC2 instances, users will also need to install the \href{https://cran.r-project.org/package=aws.ec2metadata}{aws.ec2metadata} package, which allows \code{locate_credentials} to know it is running in an instance and check for relevant values. If this package is not installed, instance metadata is not checked.

Because region is often handled slightly differently from credentials and is required for most requests (whereas some services allow anonymous requests without specifying credentials), the value of region is searched for in the same order as the above but lacking a value there fails safe with the following preference ranking of possible region values (regardless of location of other credentials):
\enumerate{
  \item a user-supplied value
  \item the \env{AWS_DEFAULT_REGION} environment variable
  \item (only on EC2 instances) a region declared in the instance metadata
  \item (if a credentials file is being used) the value specified therein
  \item the default value specified in \code{default_region} (i.e., \dQuote{us-east-1} - this can be overriden with the option \dQuote{cloudyr.aws.default_region})
}

As such, user-supplied values of \code{region} always trump any other value.
}
\seealso{
\code{\link{signature_v4}}, \code{\link{signature_v2_auth}}, \code{\link{use_credentials}}
}
