% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{combine_clean_bt_list_dbs}
\alias{combine_clean_bt_list_dbs}
\title{Combine two 'BabyTime' List Databases (DBs)}
\usage{
combine_clean_bt_list_dbs(la, lb)
}
\arguments{
\item{la}{a Clean BT List DB object}

\item{lb}{another Clean BT List DB object}
}
\value{
a Clean BT List DB object that contains all elements from `la` and `lb`
}
\description{
Generally not needed if you parse all files at once, but can be useful if
combining data extracted at multiple times or across multiple directories
}
\examples{
data_dir <- system.file('extdata', package = 'babyTimeR')
baby_dann_db_nov <- read_one_bt_activity_file(
    infile = file.path(data_dir, 'activity_Dann_202411.txt')
) |>
clean_bt_list_db()
baby_dann_db_dec<- read_one_bt_activity_file(
    infile = file.path(data_dir, 'activity_Dann_202412.txt')
) |>
clean_bt_list_db()
baby_dann_db <- combine_clean_bt_list_dbs(
    baby_dann_db_nov,
    baby_dann_db_dec
)
}
